/*
 *  Copyright (C) 2006  Helmut Grohne
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef LIBMUTH_BASESCHEDULER_H
#define LIBMUTH_BASESCHEDULER_H

#ifndef __WIN32__
#include <sys/time.h>
#endif
#include "basescheduler_decls.h"
#include "channel_decls.h"
#include "callback.h"

template<class T> inline void BaseScheduler::notifyRead(Channel<T> &chan,
		const T &value, int fd) {
	this->addReadCallback(*new ChannelCallback<T>(chan, value), fd);
}

template<class T> inline void BaseScheduler::notifyWrite(Channel<T> &chan,
		const T &value, int fd) {
	this->addWriteCallback(*new ChannelCallback<T>(&chan, value), fd);
}

template<class T> inline void BaseScheduler::notifyWait(Channel<T> &chan,
		const T &value, const timeval &tv) {
	this->addWaitCallback(*new ChannelCallback<T>(&chan, value), tv);
}

#endif
