/*
 *  Copyright (C) 2008  Helmut Grohne
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "blockingqueue.h"
#include "blockingqueue_test.h"
#include "unittest.h"

class BlockingQueueFixture : public Fixture {
	public:
		void simple();
};

void BlockingQueueFixture::simple() {
	BlockingQueue<int> b;
	if(not b.isempty())
		throw Failure("new blockingqueue not empty");
	b.put(23);
	if(b.isempty())
		throw Failure("blockingqueue empty after put");
	int r(b.get());
	if(r != 23)
		throw Failure("got wrong element from get");
	if(not b.isempty())
		throw Failure("blockingqueue not empty after get");
}

TestSuite *blockingqueue_tests() {
	TestSuite *s(new TestSuite("BlockingQueue"));
	s->addtest(new TestCase<BlockingQueueFixture>("simple",
			&BlockingQueueFixture::simple));
	return s;
}
