/*
 *  Copyright (C) 2006  Helmut Grohne
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <algorithm>
#include "callback_decls.h"
#include "microthread.h"
#include "currentthread.h"
#include "refcounter.h"

Callback::~Callback() {
}

bool Callback::iscompleted() {
	return false;
}

void ScheduleCallback::run() {
	try {
		Reference<Microthread> r(*this->microthread);
		/*
		 * TODO: Future versions may throw the same exception in the
		 * following code.
		 */
		Microthread &current(getcurrentthread());
		current.scheduleme();
		/*
		 * A static overload for two Microthreads implicitly sets the
		 * current_runner attribute.
		 */
		current.swapto(*r);
	} catch(NullPointerException&) {}
}

CallbackChain::CallbackChain(Callback *cb) {
	this->callbacks.push_back(cb);
}

void CallbackChain::add(Callback *cb) {
	this->callbacks.push_back(cb);
}

void CallbackChain::run() {
	std::for_each(this->callbacks.begin(), this->callbacks.end(),
			std::mem_fun(&Callback::run));
}

template<class T> void delete_ptr(T *p) { delete p; }

CallbackChain::~CallbackChain() {
	std::for_each(this->callbacks.begin(), this->callbacks.end(),
			delete_ptr<Callback>);
}
