/*
 *  Copyright (C) 2006  Helmut Grohne
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef LIBMUTH_CALLBACK_H
#define LIBMUTH_CALLBACK_H

#include "callback_decls.h"
#include "microthread.h"
#include "channel.h"
#include "currentthread.h"
#include "refcounter.h"
#include "suspender.h"

inline ScheduleCallback::ScheduleCallback(Microthread &m) : microthread(&m) {
}

template<class T> inline ChannelCallback<T>::ChannelCallback(Channel<T> &c,
		const T &v) : channel(c), value(v) {
}

template<class T> inline void ChannelCallback<T>::run() {
	this->channel.send(getcurrentthread(), this->value);
}

template<class T> inline SuspendCallback<T>::SuspendCallback(Suspender<T> &s,
		const T &v) : suspender(&s), value(v) {
}

template<class T> inline void SuspendCallback<T>::run() {
	this->suspender->cooperativewakeup(this->value);
}

template<class T> inline bool SuspendCallback<T>::iscompleted() {
	return this->suspender->iswakened();
}

inline CallbackChain::CallbackChain() {
}

template<class T> inline ExceptionCallback<T>::ExceptionCallback(T ex)
		: exception(ex) {
}

template<class T> inline void ExceptionCallback<T>::run() {
	throw this->exception;
}

#endif
