/*
 *  Copyright (C) 2006  Helmut Grohne
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef USE_SYSCONF_CPUS
#ifdef __WIN32__
#error "there is no sysconf on win32"
#endif
#include <algorithm>
#include <unistd.h>

#ifdef _SC_NPROCESSORS_CONF
#define SYSCONF_NPROC _SC_NPROCESSORS_CONF
#else
#ifdef _SC_NPROCESSORS_ONLN
#define SYSCONF_NPROC _SC_NPROCESSORS_ONLN
#else
#error no sysconf _SC_NPROCESSORS_* macro found
#endif
#endif

static unsigned int detect_sysconf() {
	const int cpus(sysconf(SYSCONF_NPROC));
	return cpus < 1 ? 1 : cpus;
}
#endif

unsigned int detectCPUs() {
	unsigned int cpus(1);
#ifdef USE_SYSCONF_CPUS
	cpus = std::max(cpus, detect_sysconf());
#endif
	return cpus;
}
