/*
 *  Copyright (C) 2006  Helmut Grohne
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef LIBMUTH_CPUDETECT_H
#define LIBMUTH_CPUDETECT_H

/**
 * Tries to detect the number of CPUs on a pure SMP system. Do not use this
 * function on NUMA and other non-SMP systems as two threads on different CPUs
 * will exchange a lot of memory. It is safe to use this function on single
 * processor machines.
 * @returns the number of processors or 1 if undetectable
 */
unsigned int detectCPUs();

#endif
