/*
 *  Copyright (C) 2006  Helmut Grohne
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef LIBMUTH_DUMMYCONDITION_H
#define LIBMUTH_DUMMYCONDITION_H

#ifdef USE_PTHREAD
#error this file must be compiled without -DUSE_PTHREAD
#endif

#include <assert.h>

class DummyLock;

/**
 * Internal condition implementation without threads. Thus make sure wait() is
 * never called.
 */
class DummyCondition {
	public:
		/**
		 * Condition constructor.
		 */
		inline DummyCondition(DummyLock &) {}
		/**
		 * Never call this method. In a threaded environment it would
		 * wait for other threads to notify this condition. In a
		 * single threaded environment this would obviously result in
		 * a deadlock, so this is asserted.
		 */
		inline void wait() { assert(0); }
		/**
		 * Does nothing. In a threaded environment it wakes up one
		 * threads wait()ing for this condition.
		 */
		inline void notify() {}
		/**
		 * Does nothing. In a threaded environment it wakes up all
		 * threads wait()ing for this condition.
		 */
		inline void notifyall() {}
};

#endif
