/*
 *  Copyright (C) 2006  Helmut Grohne
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef LIBMUTH_DUMMYLOCK_H
#define LIBMUTH_DUMMYLOCK_H

#ifdef USE_PTHREAD
#error this file must be compiled without -DUSE_PTHREAD
#endif

#include <assert.h>

/**
 * Internal lock implementation without threads.
 */
class DummyLock {
	private:
		bool locked;
	public:
		/**
		 * Lock constructor.
		 */
		inline DummyLock() : locked(false) {}
		/**
		 * Blockingly acquires this lock. As there is no way to release
		 * an acquired lock while acquiring it in single threaded mode
		 * this version will assert the lock not being locked.
		 */
		inline void acquire() {
				assert(this->locked == false);
				this->locked = true;
			}
		/**
		 * Tries to acquire this lock.
		 * @returns true if the lock was acquired by this call
		 */
		inline bool tryacquire() {
				if(this->locked)
					return false;
				this->locked = true;
				return true;
			}
		/**
		 * Releases this lock. If the lock is not acquired the
		 * behaviour is undefined.
		 */
		inline void release() {
				assert(this->locked == true);
				this->locked = false;
			}
		/**
		 * Lock destructor.
		 */
		inline ~DummyLock() { assert(this->locked == false); }
};

#endif
