/*
 *  Copyright (C) 2006  Helmut Grohne
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef LIBMUTH_DUMMYTHREADLOCAL_H
#define LIBMUTH_DUMMYTHREADLOCAL_H

#ifdef USE_PTHREAD
#error this file must be compiled without -DUSE_PTHREAD
#endif

/**
 * Internal threadlocal implementation without threads. This sounds silly, but
 * is needed to support the multithreaded version.
 */
template<class T> class DummyThreadLocal {
	private:
		T *data;
	public:
		/**
		 * Assignment operator which makes this object look like a
		 * pointer.
		 * @param v is the pointer to be stored
		 * @returns *this
		 */
		DummyThreadLocal &operator=(T *v) { data = v; return *this; }
		/**
		 * Dereferencing operator which makes this object look like a
		 * pointer.
		 * @returns a reference to the stored pointer
		 */
		T &operator*() { return *data; }
		/**
		 * Constant dereferencing operator which makes this object look
		 * like a pointer.
		 * @returns a reference to the stored pointer
		 */
		T &operator*() const { return *data; }
};

#endif
