/*
 *  Copyright (C) 2006  Helmut Grohne
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef LIBMUTH_EXCEPTIONS_H
#define LIBMUTH_EXCEPTIONS_H

#include <stdexcept>

/**
 * Terminates a Microthread when thrown within it.
 */
class ThreadExitException : public std::runtime_error {
	public:
		ThreadExitException() : std::runtime_error("ThreadExit") {}
};

class CleanupHandler {
	public:
		virtual ~CleanupHandler() {};
};

class CleanupHandler0 : public CleanupHandler {
	private:
		void (*func)();
	public:
		CleanupHandler0(void (*f)()) : func(f) {}
		~CleanupHandler0() { this->func(); }
};

template<class T> class CleanupHandler1 : public CleanupHandler {
	private:
		void (*func)(T);
		T arg0;
	public:
		CleanupHandler1(void (*f)(T), T a0) : func(f), arg0(a0) {}
		~CleanupHandler1() { this->func(arg0); }
};

inline CleanupHandler Finally(void (*func)()) {
	return CleanupHandler0(func);
}

template<class T> inline CleanupHandler Finally(void (*func)(T), T arg0) {
	return CleanupHandler1<T>(func, arg0);
}

#endif
