/*
 *  Copyright (C) 2006  Helmut Grohne
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <assert.h>
#include "microthread.h"
#include "runner.h"
#include "coroutine.h"
#include "currentthread.h"
#include "callback.h"
#include "exceptions.h"
#include "globalqueue.h"

void Microthread::start() {
	setcurrentthread(*this);
	try {
		this->run();
	} catch(ThreadExitException&) { }
	this->returnto(*this->current_runner);
}

inline bool Microthread::runcallback(void) {
	if(this->callback) {
		try {
			this->callback->run();
		} catch(...) {
			delete this->callback;
			this->callback = NULL;
			throw;
		}
		/* FIXME: Why is this check necessary? */
		if(this->callback) {
			delete this->callback;
			this->callback = NULL;
		}
		return true;
	} else
		return false;
}

Microthread::Microthread(BlockingQueue<Microthread*> *q)
		: callback(NULL), queue(q ? *q : getglobalqueue()) {
}

void Microthread::delayme() {
	assert(this->current_runner != NULL);
	this->swapto(*this->current_runner);
	setcurrentthread(*this);
	if(this->runcallback())
		this->delayme();
}

void Microthread::swapto(Microthread &o, bool acquired) {
	assert(this->current_runner != NULL);
	if(!acquired)
		o.acquire();
	o.current_runner = this->current_runner;
	this->Coroutine::swapto(o, true);
	setcurrentthread(*this);
	if(this->runcallback())
		this->delayme();
}

void Microthread::setcallback(Callback *cb) {
	assert(this->callback == NULL);
	this->callback = cb;
}
