/*
 *  Copyright (C) 2006  Helmut Grohne
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <assert.h>
#include <pthread.h>

#ifndef USE_PTHREAD
#error this file must be compiled with -DUSE_PTHREAD
#endif

#include "pthreadcondition.h"

PthreadCondition::PthreadCondition(PthreadLock &l) : lock(l) {
	/* Always returns 0. */
	pthread_cond_init(&this->condition, NULL);
}

void PthreadCondition::wait() {
#ifdef DEBUG_LOCK
	assert(this->lock.count == 1);
	--this->lock.count;
#endif
	/* Always returns 0. */
	pthread_cond_wait(&this->condition, &this->lock.mutex);
#ifdef DEBUG_LOCK
	assert(this->lock.count == 0);
	++this->lock.count;
#endif
}

void PthreadCondition::notify() {
	/* Always returns 0. */
	pthread_cond_signal(&this->condition);
}

void PthreadCondition::notifyall() {
	/* Always returns 0. */
	pthread_cond_broadcast(&this->condition);
}

PthreadCondition::~PthreadCondition() {
	const int e(pthread_cond_destroy(&this->condition));
	assert(e == 0);
}
