/*
 *  Copyright (C) 2006  Helmut Grohne
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef LIBMUTH_PTHREADCONDITION_H
#define LIBMUTH_PTHREADCONDITION_H

#ifndef USE_PTHREAD
#error this file must be compiled with -DUSE_PTHREAD
#endif

#include <pthread.h>

#include "pthreadlock.h"

/**
 * Internal pthread condition adaption class. This really contains a
 * pthread_mutex_t and a reference to a PthreadLock.
 */
class PthreadCondition {
	private:
		PthreadLock &lock;
		pthread_cond_t condition;
	public:
		/**
		 * Condition constructor.
		 * @param l is the lock to be unlocked while waiting
		 */
		PthreadCondition(PthreadLock &l);
		/**
		 * Waits for this condition to be notified by notify() or
		 * notifyall(). The lock passed to the constructor is released
		 * when invoking wait() and acquired before returning from it.
		 */
		void wait();
		/**
		 * Wakes up one thread wait()ing for this condition.
		 */
		void notify();
		/**
		 * Wakes up all threads wait()ing for this condition.
		 */
		void notifyall();
		~PthreadCondition();
};

#endif
