/*
 *  Copyright (C) 2006  Helmut Grohne
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <assert.h>
#include <errno.h>
#include "pthreadlock.h"

#ifndef USE_PTHREAD
#error this file must be compiled with -DUSE_PTHREAD
#endif

PthreadLock::PthreadLock() {
#ifdef DEBUG_LOCK
	this->count = 0;
#endif
	/* Always returns 0. */
	pthread_mutex_init(&this->mutex, NULL);
}

void PthreadLock::acquire() {
	const int e(pthread_mutex_lock(&this->mutex));
#ifdef DEBUG_LOCK
	++this->count;
	assert(this->count == 1);
#endif
	assert(e == 0);
}

bool PthreadLock::tryacquire() {
	const int e(pthread_mutex_trylock(&this->mutex));
	if(e == EBUSY)
		return false;
#ifdef DEBUG_LOCK
	++this->count;
	assert(this->count == 1);
#endif
	assert(e == 0);
	return true;
}

void PthreadLock::release() {
#ifdef DEBUG_LOCK
	--this->count;
	assert(this->count == 0);
#endif
	const int e(pthread_mutex_unlock(&this->mutex));
	assert(e == 0);
}

PthreadLock::~PthreadLock() {
#ifdef DEBUG_LOCK
	assert(this->count == 0);
#endif
	const int e(pthread_mutex_destroy(&this->mutex));
	assert(e == 0);
}
