/*
 *  Copyright (C) 2006  Helmut Grohne
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef LIBMUTH_PTHREADLOCK_H
#define LIBMUTH_PTHREADLOCK_H

#ifndef USE_PTHREAD
#error this file must be compiled with -DUSE_PTHREAD
#endif

#include "config.h"
#include <pthread.h>

class PthreadCondition;

/**
 * Internal pthread lock adaption class. This really contains a pthread_mutex_t.
 */
class PthreadLock {
	private:
		pthread_mutex_t mutex;
#ifdef DEBUG_LOCK
		int count;
#endif
	public:
		/**
		 * Lock constructor.
		 */
		PthreadLock();
		/**
		 * Blockingly acquires this lock. This may result in a deadlock
		 * if used improperly.
		 */
		void acquire();
		/**
		 * Tries to acquire this lock.
		 * @returns true if the lock was acquired by this call
		 */
		bool tryacquire();
		/**
		 * Releases this lock. If the lock is not acquired the
		 * behaviour is undefined.
		 */
		void release();
		/**
		 * Lock destructor.
		 */
		~PthreadLock();
		friend class PthreadCondition;
};

#endif
