/*
 *  Copyright (C) 2006-2007 Helmut Grohne
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "refcounter.h"
#include "unittest.h"

class SimpleObject : public RefCounter {
	private:
		bool &notify;
	public:
		SimpleObject(bool &n) : notify(n) {}
		~SimpleObject() { this->notify = false; }
};

class RefcounterFixture : public Fixture {
	public:
		void simpleweak();
		void weakdelete();
};

void RefcounterFixture::simpleweak() {
	bool n1(true);
	{
		Reference<SimpleObject> r(new SimpleObject(n1));
		WeakReference<SimpleObject> w(r);
		try {
			r = *w;
		} catch (NullPointerException n) {
			throw Failure("weak reference lost");
		}
	}
	if(n1)
		throw Failure("object not cleaned");
}

void RefcounterFixture::weakdelete() {
	bool n1(true), n2(true), n3(true);
	{
		Reference<SimpleObject> r(new SimpleObject(n1));
		WeakReference<SimpleObject> w(r);
		r = Reference<SimpleObject>(new SimpleObject(n2));
		if(n1)
			throw Failure("object not cleaned (1)");
		try {
			r = *w;
		} catch (NullPointerException n) {
			n3 = false;
		}
	}
	if(n2)
		throw Failure("object not cleaned (2)");
	if(n3)
		throw Failure("weak reference not cleared");
}

TestSuite* refcounter_tests() {
	TestSuite* s(new TestSuite("Refcounter"));
	s->addtest(new TestCase<RefcounterFixture>("simpleweak",
			&RefcounterFixture::simpleweak));
	s->addtest(new TestCase<RefcounterFixture>("weakdelete",
			&RefcounterFixture::weakdelete));
	return s;
}
