/*
 *  Copyright (C) 2006  Helmut Grohne
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <assert.h>
#include "runner.h"
#include "coroutine.h"

void *run_runner(void *p) {
	assert(p);
	static_cast<Runner*>(p)->run();
	return NULL;
}

void Runner::run() {
	for(;;) {
		Microthread *const m(this->queue.get());
		assert(m != NULL);
		this->swapto(*m);
	}
}

void Runner::swapto(Microthread &o, bool acquired) {
	if(!acquired)
		o.acquire();
	o.current_runner = this;
	this->Coroutine::swapto(o, true);
}

void runnerLoop(unsigned int n) {
#ifndef USE_PTHREAD
	assert(n == 1);
#else
	while(--n) {
		pthread_t pts[1];
		const int r(pthread_create(pts, NULL, run_runner,
				new Runner()));
		assert(r == 0);
	}
#endif
	(new Runner())->run();
}
