/*
 *  Copyright (C) 2006  Helmut Grohne
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef LIBMUTH_RUNNER_H
#define LIBMUTH_RUNNER_H

#include "blockingqueue_decls.h"
#include "coroutine_decls.h"
#include "microthread.h"
#include "globalqueue.h"

/**
 * Processes a BlockingQueue of Microthread.
 */
class Runner : public Coroutine {
	private:
		using Coroutine::swapto;
		/**
		 * Continues execution of Microthread o.
		 * @param o the Microthread to be continued
		 * @param acquired if the Microthread is acquired true must be
		 * 		   given here
		 */
		void swapto(Microthread &o, bool acquired=false);
		BlockingQueue<Microthread*> &queue;
	public:
		/**
		 * Constructs a Runner that works on the queue q.
		 * @param q is the queue to work on
		 */
		inline Runner(BlockingQueue<Microthread*> *q=NULL)
				: queue(q ? *q : getglobalqueue()) {}
		/**
		 * Runs the Runner. This will not return. This method will also
		 * be invoked by run_runner().
		 * @see run_runner
		 */
		void run();
};

/**
 * Casts and runs the given Runner. This is useful in conjunction with
 * pthread_create() for instance.
 * @param p is casted to Runner*
 */
void *run_runner(void *p);

/**
 * Starts n Runners. When compiling without threads n must be exactly 1 or be
 * omitted.
 * @param n is the number of Runners to boot
 * @returns never
 */
void  runnerLoop(unsigned int n=1);

#endif
