/*
 *  Copyright (C) 2006  Helmut Grohne
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __WIN32__
#include <sys/select.h>
#else
#include <winsock.h>
#endif
#include <assert.h>
#include "suspender.h"
#include "callback.h"
#include "timeval.h"
#include "basescheduler_decls.h"

int selectwrapper(BaseScheduler &sched, int maxfd, fd_set *rfds, fd_set *wfds,
		fd_set *efds, struct timeval *timeout) {
	Reference<Suspender<int> > sp = &Suspender<int>::create();
	int i;
	assert(maxfd <= (INT_MAX>>2));
	Timeval tv(TimevalNow);
	if(timeout)
		sched.addWaitCallback(*new SuspendCallback<int>(*sp, -1),
				*timeout);
	if(rfds) {
		for(i=0;i<maxfd;++i)
			if(FD_ISSET(i, rfds))
				sched.addReadCallback(*new SuspendCallback<int>
							(*sp, i<<2), i);
		FD_ZERO(rfds);
	}
	if(wfds) {
		for(i=0;i<maxfd;++i)
			if(FD_ISSET(i, wfds))
				sched.addWriteCallback(*new SuspendCallback<int>
							(*sp, (i<<2)|1), i);
		FD_ZERO(wfds);
	}
	if(efds) {
		for(i=0;i<maxfd;++i)
			if(FD_ISSET(i, efds))
				sched.addWriteCallback(*new SuspendCallback<int>
							(*sp, (i<<2)|2), i);
		FD_ZERO(efds);
	}

	i = sp->suspend();
	if(i < 0) {
		assert(timeout != NULL);
		timeout->tv_sec = timeout->tv_usec = 0;
		return 0;
	}
	if(timeout) {
		tv = Timeval(TimevalNow) - tv;
		timeout->tv_sec = tv.tv_sec;
		timeout->tv_usec = tv.tv_usec;
	}
	if((i & 3) == 0) {
		assert(rfds != NULL);
		FD_SET(i>>2 , rfds);
	} else if((i & 3) == 1) {
		assert(wfds != NULL);
		FD_SET(i>>2, wfds);
	} else {
		assert(efds != NULL);
		FD_SET(i>>2, efds);
	}
	return 1;
}
