/*
 *  Copyright (C) 2006  Helmut Grohne
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef LIBMUTH_SELECTWRAPPER_H
#define LIBMUTH_SELECTWRAPPER_H

/**
 * Should behave like the function described in man 2 select.
 * @param sched is the scheduler to be used
 * @param rfds see man 2 select
 * @param wfds see man 2 select
 * @param efds see man 2 select
 * @param timeout see man 2 select
 * @returns see man 2 select
 */
int selectwrapper(BaseScheduler &sched, int maxfd, fd_set *rfds, fd_set *wfds,
		fd_set *efds, struct timeval *timeout);

#endif
