/*
 *  Copyright (C) 2006  Helmut Grohne
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef LIBMUTH_SUSPENDER_H
#define LIBMUTH_SUSPENDER_H

#include <assert.h>
#include "suspender_decls.h"
#include "currentthread.h"

template<class T> T Suspender<T>::suspend() {
	this->lock.acquire();
	assert(this->microthread == NULL);
	if(!this->wakened) {
		Microthread *m(this->microthread = &getcurrentthread());
		this->lock.release();
		m->delayme();
	} else
		this->lock.release();
	assert(this->wakened == true);
	return this->retval;
}

template<class T> bool Suspender<T>::wakeup(const T &rv) {
	this->lock.acquire();
	if(this->wakened) {
		this->lock.release();
		return false;
	}
	this->retval = rv;
	this->wakened = true;
	if(Microthread *m = this->microthread) {
		this->lock.release();
		m->scheduleme();
	} else
		this->lock.release();
	return true;
}

template<class T> bool Suspender<T>::cooperativewakeup(const T &rv) {
	this->lock.acquire();
	if(this->wakened) {
		this->lock.release();
		return false;
	}
	this->wakened = true;
	this->retval = rv;
	if(Microthread *m = this->microthread) {
		this->lock.release();
		Microthread &me(getcurrentthread());
		me.scheduleme();
		me.swapto(*m);
	} else
		this->lock.release();
	return true;
}

template<class T> inline bool Suspender<T>::issuspended() const {
	/* TODO: unlocked! necessary? */
	return this->microthread != NULL && !this->wakened;
}

template<class T> inline bool Suspender<T>::iswakened() const {
	/* TODO: unlocked! necessary? */
	return this->wakened;
}

template<class T> inline bool Suspender<T>::iscompleted() const {
	/* TODO: unlocked! necessary? */
	return this->microthread != NULL && this->wakened;
}

#endif
