/*
 *  Copyright (C) 2006  Helmut Grohne
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "timeval.h"
#include "unittest.h"

class TimevalFixture : public Fixture {
	private:
		Timeval now;
	public:
		TimevalFixture() : now(TimevalNow) {}
		void addfloat();
		void subfloat();
};

void TimevalFixture::addfloat() {
	Timeval b(now + 0.1);
	if(b <= now)
		throw Failure("a + 0.1 <= a");
	b = now + 1.1;
	if(b <= now)
		throw Failure("a + 1.1 <= a");
	b = now;
	b += 0.000002;
	if(b <= now)
		throw Failure("a += 0.000001 <= a");
}

void TimevalFixture::subfloat() {
	Timeval b(now - 0.1);
	if(b >= now)
		throw Failure("a - 0.1 >= a");
	b = now - 1.1;
	if(b >= now)
		throw Failure("a - 1.1 >= a");
	b = now;
	b -= 0.000002;
	if(b >= now)
		throw Failure("a -= 0.000001 >= a");
}

TestSuite *timeval_tests() {
	TestSuite *s=new TestSuite("Timeval");
	s->addtest(new TestCase<TimevalFixture>("addfloat",
			&TimevalFixture::addfloat));
	s->addtest(new TestCase<TimevalFixture>("subfloat",
			&TimevalFixture::subfloat));
	return s;
}
