/*
 *  Copyright (C) 2006  Helmut Grohne
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <algorithm>
#include <iostream>
#include <memory>
#include <assert.h>
#include "unittest.h"

Fixture::~Fixture() {
}

void BaseGatherer::pending(int) {
}

BaseGatherer::~BaseGatherer() {
}

BaseGatherer &BaseGatherer::forwardto() {
	return *this;
}

const std::string &BaseGatherer::prefixed() const {
	static const std::string empty(""); 
	return empty;
}

std::auto_ptr<BaseGatherer> ForwardGatherer::clone() {
	assert(dynamic_cast<ForwardGatherer*>(&this->gatherer) == NULL);
	return std::auto_ptr<BaseGatherer>(new ForwardGatherer(this->gatherer,
			this->prefix));
}

void ForwardGatherer::succeed(const std::string &n) {
	this->gatherer.succeed(this->prefix + n);
}

void ForwardGatherer::fail(const std::string &n, const std::string &r) {
	this->gatherer.fail(this->prefix + n, r);
}

void ForwardGatherer::pending(int n) {
	this->gatherer.pending(n);
}

BaseGatherer &ForwardGatherer::forwardto() {
	return this->gatherer;
}

const std::string &ForwardGatherer::prefixed() const {
	return this->prefix;
}

std::auto_ptr<BaseGatherer> Gatherer::clone() {
	return std::auto_ptr<BaseGatherer>(new ForwardGatherer(*this, ""));
}

void Gatherer::succeed(const std::string &n) {
	++this->succeeded;
	std::cout << n << ": succeeded" << std::endl;
}

void Gatherer::fail(const std::string &n, const std::string &r) {
	++this->failed;
	std::cout << n << ": failed: " << r << std::endl;
}

void Gatherer::stats() {
	std::cout << "test summary: "
		<< this->succeeded
		<< "/"
		<< (this->succeeded + this->failed)
		<< " passed" << std::endl;
}

int Gatherer::failed_tests() {
	return this->failed;
}

BaseTest::~BaseTest() {
}

TestSuite *TestSuite::clone() const {
	return new TestSuite(*this);
}

void TestSuite::addtest(BaseTest *t) {
	this->tests.push_back(t);
}

void TestSuite::run(BaseGatherer &g) {
	ForwardGatherer f(g, this->name + "::");
	g.pending(this->tests.size()); // O(n)
	for(std::list<BaseTest*>::iterator i=this->tests.begin();
			i!=this->tests.end();++i)
		unittest_run(*i, f);
	g.pending(-1);
}

template<class T> void delete_ptr(T *p) { delete p; }

TestSuite::~TestSuite() {
	std::for_each(this->tests.begin(), this->tests.end(),
			delete_ptr<BaseTest>);
}

