/*
 *  Copyright (C) 2006  Helmut Grohne
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef LIBMUTH_UNITTEST_H
#define LIBMUTH_UNITTEST_H

#include "unittest_decls.h"

inline ForwardGatherer::ForwardGatherer(BaseGatherer &g, const std::string &p)
		: gatherer(g.forwardto()), prefix(g.prefixed() + p) {
}

inline Gatherer::Gatherer() : succeeded(0), failed(0) {
}

inline BaseTest::BaseTest(const std::string &n) : name(n) {
}

template<class F> inline TestCase<F>::TestCase(const std::string &n,
		void (F::*func)()) : BaseTest(n), function(func) {
}

template<class F> inline TestCase<F>::TestCase(const TestCase<F> &o)
		: BaseTest(o), function(o.function) {
}

template<class F> inline TestCase<F> *TestCase<F>::clone() const {
	return new TestCase<F>(*this);
}

template<class F> void TestCase<F>::run(BaseGatherer &g) {
	F fixture;
	bool succeeded(false);
	try {
		(fixture.*function)();
		succeeded = true;
	} catch(Failure &f) {
		g.fail(this->name, f.what());
	} catch(...) {
		g.fail(this->name, std::string("unknown exception caught"));
	} if(succeeded)
		g.succeed(this->name);
}

inline TestSuite::TestSuite(const std::string &n) : BaseTest(n) {
}

inline TestSuite::TestSuite(const TestSuite &o) : BaseTest(o) {
	for(std::list<BaseTest*>::const_iterator i(o.tests.begin());
			i!=o.tests.end();
			++i)
		this->tests.push_back((*i)->clone());
}

inline Failure::Failure(const std::string &r) : std::runtime_error(r) {
}

#endif
