/*
 *  Copyright (C) 2006  Helmut Grohne
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <iostream>
#include <memory>
#include "unittest.h"
#include "blockingqueue_test.h"
#include "refcounter_test.h"
#include "timeval_test.h"

class DummyFixture : public Fixture {
	private:
		bool ready;
	public:
		DummyFixture() : ready(true) {}
		void nothing() {}
		void setuptest() {if(!this->ready) throw Failure("not ready");}
};

TestSuite *dummy_tests() {
	TestSuite *s(new TestSuite("example"));
	s->addtest(new TestCase<DummyFixture>("nothing",
			&DummyFixture::nothing));
	s->addtest(new TestCase<DummyFixture>("setuptest",
			&DummyFixture::setuptest));
	return s;
}

int main() {
	TestSuite *s(new TestSuite(""));
	s->addtest(dummy_tests());
	s->addtest(blockingqueue_tests());
	s->addtest(refcounter_tests());
	s->addtest(timeval_tests());
	unittest_main(std::auto_ptr<BaseTest>(s));
	return 0;
}
