/*
 *  Copyright (C) 2006  Helmut Grohne
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __WIN32__
#error "this include is only for win32"
#endif

#include <string.h>
#include <assert.h>
#include "win32.h"

int getcontext(ucontext_t *ucp)
{
	assert(ucp != NULL);
	ucp->winctx.ContextFlags = CONTEXT_FULL;
	return GetThreadContext(GetCurrentThread(), &ucp->winctx);
}

int setcontext(const ucontext_t *ucp)
{
	assert(ucp != NULL);
	return SetThreadContext(GetCurrentThread(), &ucp->winctx);
}

int makecontext(ucontext_t *ucp, void (*func)(), int argc, ...)
{
	assert(ucp != NULL);
	assert(func != NULL);
	assert(argc == 0);

	char *sp((char *)ucp->uc_stack.ss_sp + ucp->uc_stack.ss_size);
	ucp->winctx.Eip = (unsigned long)func;
	ucp->winctx.Esp = (unsigned long)sp - 4;
	ucp->winctx.ContextFlags = CONTEXT_FULL;
	return 0;
}

int swapcontext(ucontext_t *oucp, const ucontext_t *ucp)
{
	assert(oucp != NULL);
	assert(ucp != NULL);
	const int r(getcontext(oucp));
	if(r != 0) return r;
	return setcontext(ucp);
}
