/*
 *  Copyright (C) 2006  Helmut Grohne
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __WIN32__
#error "this include is only for win32"
#endif

#ifndef LIBMUTH_WIN32_H
#define LIBMUTH_WIN32_H

#define LIBMUTH_NEED_UINT64_T
#define LIBMUTH_NEED_SOCKLEN_T
#define LIBMUTH_NEED_SUSECONDS_T
/* #define LIBMUTH_NEED_SIZE_T */
#define LIBMUTH_NEED_SSIZE_T

#ifndef NOMINMAX
#define NOMINMAX
#endif
#include <windows.h>
#include <winsock.h>

#ifdef LIBMUTH_NEED_UINT64_T
/* Windows doesn't seem to be able to handle long long, so this uint64_t will
 * have only 32 bits. */
typedef unsigned long uint64_t;
#endif
#ifdef LIBMUTH_NEED_SOCKLEN_T
typedef int socklen_t;
#endif
#ifdef LIBMUTH_NEED_SUSECONDS_T
typedef long suseconds_t;
#endif
#ifdef LIBMUTH_NEED_SIZE_T
typedef unsigned long size_t;
#endif
#ifdef LIBMUTH_NEED_SSIZE_T
typedef long ssize_t;
#endif

typedef struct {
	void *ss_sp;
	size_t ss_size;
	int ss_flags;
} stack_t;

typedef unsigned long __sigset_t;

typedef struct {
	stack_t uc_stack;
	CONTEXT winctx;
} ucontext_t;

int getcontext(ucontext_t *ucp);
int setcontext(const ucontext_t *ucp);
int makecontext(ucontext_t *, void (*)(), int, ...);
int swapcontext(ucontext_t *, const ucontext_t *);

#endif
